#pragma once

#include "diff_details.h"
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/revision/commit.h>

namespace maps {
namespace wiki {

class ObjectsCache;
class GetCommitGeomDiff;

template<>
struct controller::ResultType<GetCommitGeomDiff>
{
    GeomDiff geomDiff;
};

class GetCommitGeomDiff: public controller::BaseController<GetCommitGeomDiff>
{
public:
    struct Request
    {
        TCommitId commitId;
        TOid objectId;
        TUid user;
        Token dbToken;
        TBranchId branchId;
        std::string bboxString;
        TZoom zoom;
    };

    explicit GetCommitGeomDiff(const Request& request);

    virtual ~GetCommitGeomDiff();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
