#pragma once
#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include "maps/wikimap/mapspro/services/editor/src/exception.h"
#include <yandex/maps/wiki/revision/diff.h>
#include <optional>

namespace maps {
namespace wiki {
class ObjectsCache;

struct ThreadStopDiffRecord
{
    enum class Type {
        Added,
        Removed,
        Modified,
        Context
    };
    Type type;
    TOid id;
    std::string title;
    std::optional<revision::AttributesDiff> attrsDiff;
};

typedef std::vector<ThreadStopDiffRecord> ThreadStopDiffRecords;

struct ThreadStopDiff
{
    ThreadStopDiff(): brokenSequence(false) {}
    ThreadStopDiffRecords diffs;
    bool brokenSequence;
};


const std::string& toString(ThreadStopDiffRecord::Type);

ThreadStopDiff
threadsDiff(ObjectPtr after, ObjectPtr before,
    ObjectsCache* cacheAfter, ObjectsCache* cacheBefore);

} // namespace wiki
} // namespace maps
