#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps {
namespace wiki {

class ObserverCollection;
class CommitsApprove;
template<>
struct controller::ResultType<CommitsApprove>
{
    CommitModels commitModels;
    Token token;
    social::TaskIds taskIds;
};

class CommitsApprove : public controller::BaseController<CommitsApprove>
{
public:
    struct Request
    {
        Request(TUid uid, TCommitId commitId);

        std::string dump() const;
        TUid userId() const { return user; }

        const TUid user;
        const TCommitId commitId;
    };

    CommitsApprove(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void processApprove();

    const Request request_;
};

} // namespace wiki
} // namespace maps
