#include "get_commit.h"

#include <maps/wikimap/mapspro/services/editor/src/exception.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>

#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <yandex/maps/wiki/revision/branch_manager.h>

namespace maps {
namespace wiki {

GetCommit::GetCommit(const Request& request)
    : controller::BaseController<GetCommit>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
    CHECK_REQUEST_PARAM(request.commitId);
}

std::string
GetCommit::Request::dump() const
{
    std::stringstream ss;

    ss << " commit:" << commitId;
    ss << " uid: " << uid;
    ss << " branch: " << branchId;
    ss << " token: " << dbToken;
    return ss.str();
}

std::string
GetCommit::printRequest() const
{
    return request_.dump();
}

void
GetCommit::control()
{
    auto branchCtx = BranchContextFacade::acquireRead(
        request_.branchId, request_.dbToken);

    result_->commitModelPtr = make_unique<CommitModel>(
        revision::Commit::load(branchCtx.txnCore(), request_.commitId));

    result_->commitModelPtr->setupState(branchCtx);
    result_->commitModelPtr->setupApproveStatus(branchCtx);
    result_->commitModelPtr->setupFeedbackTaskId(branchCtx);

}

} // namespace wiki
} // namespace maps
