#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/commit.h>

#include <yandex/maps/wiki/revision/commit.h>

namespace maps {
namespace wiki {

class GetCommit;

template<>
struct controller::ResultType<GetCommit>
{
    std::unique_ptr<CommitModel> commitModelPtr;
};

class GetCommit: public controller::BaseController<GetCommit>
{
public:
    struct Request
    {
        std::string dump() const;

        TCommitId commitId;
        TUid uid;
        TBranchId branchId;
        Token dbToken;
    };

    explicit GetCommit(const Request& request);

    virtual ~GetCommit() {}

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
