#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/commit.h>

#include <yandex/maps/wiki/revision/commit.h>

namespace maps {
namespace wiki {

class GetDependentCommits;
template<>
struct controller::ResultType<GetDependentCommits>
{
    CommitModels commitModels;
    size_t totalCount;
    size_t page;
    size_t perPage;
};

class GetDependentCommits: public controller::BaseController<GetDependentCommits>
{
public:
    struct Request
    {
        TUid uid;
        TCommitId commitId;
        size_t page;
        size_t perPage;
        Token token;

        void check() const;
        std::string dump() const;
    };

    explicit GetDependentCommits(const Request& request);

    std::string printRequest() const override;

protected:
    void control() override;

private:
    const Request request_;

};

} // namespace wiki
} // namespace maps
