#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <maps/wikimap/mapspro/services/editor/src/user_context.h>

#include <yandex/maps/wiki/revision/commit.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps {
namespace wiki {

class ObserverCollection;
class CommitsRevert;
template<>
struct controller::ResultType<CommitsRevert>
{
    std::unique_ptr<CommitModel> commitModel;
    Token token;
    social::TaskIds taskIds;
};

class CommitsRevert : public controller::BaseController<CommitsRevert>
{
public:
    struct Request
    {
        Request(
            UserContext userContext,
            TCommitId commitId,
            boost::optional<RevertReason> revertReason,
            boost::optional<TId> feedbackTaskId);

        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        UserContext userContext;
        const TCommitId commitId;
        const boost::optional<RevertReason> revertReason;
        const boost::optional<TId> feedbackTaskId;
    };

    CommitsRevert(
        const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void processRevert();

    const ObserverCollection& observers_;
    Request request_;
};

} // namespace wiki
} // namespace maps
