#pragma once

#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <maps/wikimap/mapspro/services/editor/src/user_context.h>

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <yandex/maps/wiki/revision/commit_manager.h>

namespace maps {
namespace wiki {

class ObserverCollection;

struct EditorRevertData
{
    revision::Commit createdCommit;
    revision::DBIDSet revertedCommitIds;
    TOIds primaryOids;
};

class CommitsReverter
{
public:
    CommitsReverter(
        const ObserverCollection& observers,
        BranchContext& branchCtx,
        UserContext& userContext,
        boost::optional<TId> feedbackTaskId = boost::none);

    TUid uid() const { return userContext_.uid(); }
    const acl::User& user() { return userContext_.aclUser(branchCtx_); }

    EditorRevertData revertCommits(
        const TCommitIds& commitIds,
        const boost::optional<RevertReason>& revertReason) const;

    Token syncViewAndCommit(const EditorRevertData& revertData);

protected:
    virtual void checkRevertedCommit(
        const revision::Commit& commit,
        const TCommitIds& allRevertedCommitIds) const;

    BranchContext& branchCtx() const { return branchCtx_; }

private:
    const ObserverCollection& observers_;
    BranchContext& branchCtx_;
    UserContext& userContext_;
    const boost::optional<TId> feedbackTaskId_;
};

} // namespace wiki
} // namespace maps
