#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/context.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"
#include "maps/wikimap/mapspro/services/editor/src/view.h"
#include "maps/wikimap/mapspro/services/editor/src/collection.h"
#include "maps/wikimap/mapspro/services/editor/src/topo_storage.h"
#include "maps/wikimap/mapspro/services/editor/src/objectvisitor.h"
#include "maps/wikimap/mapspro/services/editor/src/topological/topological_callbacks.h"
#include "maps/wikimap/mapspro/services/editor/src/context.h"
#include "maps/wikimap/mapspro/services/editor/src/serialize/topo_object_data.h"

#include <yandex/maps/wiki/topo/editor.h>

#include <string>
#include <sstream>

namespace maps {
namespace wiki {

namespace topo {

class Editor;

} // namespace topo

class ObjectsCache;
class Context;
class TopologyEditContext;

class CreateIntersections;

template<>
struct controller::ResultType<CreateIntersections>
{
    std::map<TOid, GeoObjectCollection> splitObjects;
    TopoObjectDataCollection adjustedObjects;
    std::shared_ptr<ObjectsCache> cache;
    std::string taskName;
    Token token;
};

class CreateIntersections : public controller::BaseController<CreateIntersections>
{
public:
    struct Request
    {
        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        UserContext userContext;
        TBranchId branchId;
        TopoObjectDataCollection objectsUpdateData;
        ObjectEditContextPtr editContext;
        boost::optional<TId> feedbackTaskId;
    };

    CreateIntersections(
        const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    ~CreateIntersections();

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:

    virtual void control();

    void initTopologyEditContext(Context&);
    void checkObjectRevisions(Context&);

    bool doWork(Context&);


    const ObserverCollection& observers_;

    Request request_;

    // Required for TopologyEditContext;
    NewLinearElementsDataMap newLinearElementsData_;

    std::unique_ptr<TopologyEditContext> topologyEditContext_;
};

} // namespace wiki
} // namespace maps
