#include "create_token.h"
#include "maps/wikimap/mapspro/services/editor/src/branch_helpers.h"

namespace maps {
namespace wiki {

CreateToken::CreateToken(
        const Request& request)
    : controller::BaseController<CreateToken>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{ }

std::string CreateToken::printRequest() const
{ return "branch: " + std::to_string(request_.branch); }

void CreateToken::control()
{
    auto branchCtx = BranchContextFacade(request_.branch).acquireWrite();
    result_->token = branchCtx.commit();
    result_->taskName = "CreateToken";
}

} // namespace wiki
} // namespace maps
