#include "delete_filter.h"
#include "magic_strings.h"

#include <maps/wikimap/mapspro/services/editor/src/check_permissions.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/exception.h>

#include <yandex/maps/wiki/filters/stored_filter.h>
#include <yandex/maps/wiki/filters/exception.h>


namespace maps {
namespace wiki {

namespace {
    const std::string TASK_METHOD_NAME = "DeleteFilter";
} // namespace

DeleteFilter::DeleteFilter(
        const Request& request)
    : controller::BaseController<DeleteFilter>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{ }

std::string DeleteFilter::printRequest() const
{
    std::stringstream ss;
    ss << " uid: " << request_.uid
       << " filterId: " << request_.filterId;
    return ss.str();
}

void DeleteFilter::control()
{
    auto work = cfg()->poolCore().masterWriteableTransaction();
    CheckPermissions checkPermissions(request_.uid, *work);
    checkPermissions.checkPermissionsToEditFilters();
    try {
        auto filter = filters::StoredFilter::load(*work, request_.filterId);
        WIKI_REQUIRE(
            filter.createdBy() == request_.uid ||
                checkPermissions.isUserHasAccessToEditPublicFilters(),
            ERR_FORBIDDEN,
            "No access to delete filter id: " << request_.filterId) << " user uid:" << request_.uid;

        filter.setDeleted(*work);
    } catch (const filters::FilterNotFound&) {
        THROW_WIKI_LOGIC_ERROR(
                ERR_FILTER_NOT_FOUND,
                "filter id: " << request_.filterId << " does not exist");
    }

    result_->token = pgpool3::generateToken(*work);
    result_->taskName = TASK_METHOD_NAME;
    work->commit();
}

} // namespace wiki
} // namespace maps
