#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/filters/stored_expression.h>

#include <memory>

namespace maps {
namespace wiki {

class GetFilterExpression;
template<>
struct controller::ResultType<GetFilterExpression>
{
    bool isSQLFormat;
    std::unique_ptr<filters::StoredExpression> expression;
    std::string viewSql;
};

class GetFilterExpression : public controller::BaseController<GetFilterExpression>
{
public:
    struct Request
    {
        const filters::TExpressionId id;
        const std::string format;
        const Token token;
    };

    explicit GetFilterExpression(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;

};

} // namespace wiki
} // namespace maps
