#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/common/before_after.h>
#include <yandex/maps/wiki/filters/stored_filter.h>

namespace maps {
namespace wiki {

class GetFilters;
template<>
struct controller::ResultType<GetFilters>
{
    std::vector<filters::StoredFilter> filters;
    size_t page;
    size_t perPage;
    size_t totalCount;
    std::optional<bool> hasMore;
};

class GetFilters : public controller::BaseController<GetFilters>
{
public:
    struct Request
    {
        const TUid uid;
        const boost::optional<TUid> createdBy;

        const size_t page;
        const size_t perPage;

        common::BeforeAfter beforeAfter;
        filters::TFilterId startId;
        size_t limit;
        std::string namePart;
        const Token token;
    };

    explicit GetFilters(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
