#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/filters/stored_expression.h>

namespace maps {
namespace wiki {

class SaveExpression;
template<>
struct controller::ResultType<SaveExpression>
{
    std::unique_ptr<filters::StoredExpression> expression;
    Token token;
};

class SaveExpression : public controller::BaseController<SaveExpression>
{
public:
    struct Request
    {
        const TUid uid;
        const std::string expression;
    };

    explicit SaveExpression(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;

};

} // namespace wiki
} // namespace maps
