#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/filters/stored_filter.h>

namespace maps {
namespace wiki {

class SaveFilter;
template <>
struct controller::ResultType<SaveFilter>
{
    std::unique_ptr<filters::StoredFilter> filter;
    Token token;
};

class SaveFilter : public controller::BaseController<SaveFilter>
{
public:
    struct Request
    {
        const TUid uid;
        const filters::TFilterId filterId;
        const std::string filterName;
        const bool isPublic;
        const std::string expression;
    };

    explicit SaveFilter(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;

};

} // namespace wiki
} // namespace maps
