#include "serialization.h"

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/serialize/common.h>
#include <maps/wikimap/mapspro/services/editor/src/utils.h>
#include <yandex/maps/wiki/common/date_time.h>
#include <yandex/maps/wiki/common/json_helpers.h>
#include <yandex/maps/wiki/common/string_utils.h>

#include <ostream>

namespace maps {
namespace wiki {

void serializeFilter(
        const filters::StoredFilter& storedFilter,
        std::ostream& os)
{
    os << "<filter"
       << " id=\"" << storedFilter.id() << "\""
       << " created-by=\"" << storedFilter.createdBy() << "\""
       << " created-at=\"" << common::canonicalDateTimeString(storedFilter.createdAt(),
          common::WithTimeZone::Yes) << "\""
       << " public=\"" << (storedFilter.isPublic() ? "true" : "false")
       << "\">";

    os << "<name>"
       << common::escapeCData(storedFilter.name())
       << "</name>";

    serializeExpression(storedFilter.expression(), os);

    os << "</filter>";
}

void serializeFilter(
        const filters::StoredFilter& storedFilter,
        json::ObjectBuilder& filterBuilder)
{
    filterBuilder[STR_ID] = common::idToJson(storedFilter.id());
    filterBuilder[STR_CREATEDAT] = common::canonicalDateTimeString(storedFilter.createdAt(),
          common::WithTimeZone::Yes);
    filterBuilder[STR_CREATEDBY] = common::idToJson(storedFilter.createdBy());
    filterBuilder[STR_PUBLIC] = storedFilter.isPublic();
    filterBuilder[STR_NAME] = storedFilter.name();
    const auto& expression = storedFilter.expression();
    filterBuilder[STR_EXPRESSION] <<
        [&](json::ObjectBuilder expressionBuilder) {
            serializeExpression(expression, expressionBuilder);
        };
}

void serializeExpression(
        const filters::StoredExpression& expr,
        std::ostream& os)
{
    os << "<expression"
       << " id=\"" << expr.id() << "\""
       << " created-by=\"" << expr.createdBy() << "\""
       << " created-at=\"" << common::canonicalDateTimeString(expr.createdAt(),
          common::WithTimeZone::Yes) << "\""
       << " lang-version=\"" << expr.langVersion() << "\">"
       << common::escapeCData(expr.text())
       << "</expression>";
}

void serializeExpression(
        const filters::StoredExpression& expression,
        json::ObjectBuilder& expressionBuilder)
{
    expressionBuilder[STR_ID] = common::idToJson(expression.id());
    expressionBuilder[STR_CREATEDAT] = common::canonicalDateTimeString(expression.createdAt(),
          common::WithTimeZone::Yes);
    expressionBuilder[STR_CREATEDBY] = common::idToJson(expression.createdBy());
    expressionBuilder[STR_LANG_VERSION] = expression.langVersion();
    expressionBuilder[STR_TEXT] = expression.text();
}

} // namespace wiki
} // namespace maps
