#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/geolocks/geolocks.h>

namespace maps {
namespace wiki {

class GetGeoLocks;
template<>
struct controller::ResultType<GetGeoLocks>
{
    std::list<geolocks::GeoLock> locks;
    TBranchId branchId;
    revision::BranchState branchState;
};

class GetGeoLocks: public controller::BaseController<GetGeoLocks>
{
public:
    struct Request
    {
        const TUid uid;
        const TBranchId branchId;
        std::string bboxStr;
    };

    explicit GetGeoLocks(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void loadData(pqxx::transaction_base& work);

    const Request request_;

};

} // namespace wiki
} // namespace maps
