#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include "maps/wikimap/mapspro/services/editor/src/approve_status.h"
#include "maps/wikimap/mapspro/services/editor/src/commit.h"

#include <yandex/maps/wiki/revision/commit.h>

namespace maps
{
namespace wiki
{
class GetHistory;
template<>
struct controller::ResultType<GetHistory>
{
    CommitModels commitModels;
    size_t totalCount;
    TOid oid;
    size_t page;
    size_t perPage;
};

class GetHistory: public controller::BaseController<GetHistory>
{
public:
    enum class RelationsChangePolicy {
        Show,
        Hide
    };
    enum class IndirectChangePolicy {
        Show,
        Hide
    };
    struct Request
    {
        TOid oid;
        TUid user;
        Token token;
        TBranchId branchId;
        size_t page;
        size_t perPage;
        RelationsChangePolicy relationsChangePolicy;
        IndirectChangePolicy indirectChangePolicy;
    };

    explicit GetHistory(const Request& request);
    virtual ~GetHistory() {}

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;

};

} // namespace wiki
} // namespace maps
