#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include "maps/wikimap/mapspro/services/editor/src/common.h"

namespace maps {
namespace wiki {

class GetRichContent;
template<>
struct controller::ResultType<GetRichContent>
{
    std::string decodedData;
    std::string contentType;
    std::string contentDisposition;
};

class GetRichContent: public controller::BaseController<GetRichContent>
{
public:
    struct Request
    {
        TUid uid;
        TOid objectId;
        TRevisionId revisionId;
        TBranchId branchId;
        Token token;

        std::string dump() const;
    };

    GetRichContent(const Request& request);
    virtual ~GetRichContent();

    virtual std::string printRequest() const;

protected:
    virtual void control();

    Request request_;
};

} //namespace wiki
} //namespace maps
