#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/collection.h"

namespace maps
{
namespace wiki
{
class ObjectsCache;

struct RelativeLink
{    
    TOid relative;
    std::string roleId;
};

class GetTopology;
template<>
struct controller::ResultType<GetTopology>
{
    ResultType<GetTopology>() : isComplete(false) {}
    std::unique_ptr<ObjectsCache> cache;
    GeoObjectCollection linearElements;
    GeoObjectCollection junctions;
    GeoObjectCollection adjacentLinearElements;
    std::map<TOid, std::multimap<std::string, const GeoObject*>> objectsLinks;
    bool isComplete;
};

class GetTopology: public controller::BaseController<GetTopology>
{
public:
    struct Request
    {
        TOid oid;
        Token token;        
        std::string bbox;
        TBranchId branchId;
    };

    explicit GetTopology(const Request& request);
    virtual ~GetTopology() {}

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void topologyByBBox(const ObjectPtr& object, ObjectsCache& cache);

    const Request request_;

};


} // namespace wiki
} // namespace maps
