#include "getasyncresult.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

#include <maps/wikimap/mapspro/libs/taskutils/include/taskutils.h>

namespace maps::wiki {

GetAsyncResult::GetAsyncResult(const Request& request)
    : controller::BaseController<GetAsyncResult>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

std::string
GetAsyncResult::printRequest() const
{
    std::stringstream ss;
    ss << " task token id: " << request_.tokenStr_;
    return ss.str();
}

void
GetAsyncResult::control()
{
    const auto& asyncTasksSupport = cfg()->asyncTasksSupport();
    const auto& tokenSecretWord = asyncTasksSupport.manager().tokenSecretWord();
    make_unique<controller::AsyncTaskResult>(taskutils::Token(request_.tokenStr_, tokenSecretWord))
        .swap(result_->asyncTaskResult);
    result_->asyncTaskResult->load(asyncTasksSupport);
}

} // namespace maps::wiki
