#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/libs/controller/include/asynctaskresult.h>

namespace maps
{
namespace wiki
{
class GetAsyncResult;
template<>
struct controller::ResultType<GetAsyncResult>
{
    std::unique_ptr<controller::AsyncTaskResult> asyncTaskResult;
};

class GetAsyncResult: public controller::BaseController<GetAsyncResult>
{
public:
    struct Request
    {
        Request(const std::string& taskTokenStr)
            : tokenStr_(taskTokenStr)
        {}
        std::string tokenStr_;
    };

    explicit GetAsyncResult(const Request& request);
    virtual ~GetAsyncResult() {}
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};


}//wiki
}//maps
