#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/collection.h"

#include <string>
#include <memory>

namespace maps {
namespace wiki {


class ObjectsCache;
class GetObject;
template<>
struct controller::ResultType<GetObject>
{
    GeoObjectCollection collection;
    std::unique_ptr<ObjectsCache> cache;
    std::string noLoadSlavesRoleId;
    TRevisionId actualObjectRevisionId;
    TUid userId;
};


class GetObject: public controller::BaseController<GetObject>
{
public:
    enum class SubstitutionPolicy
    {
        Allow,
        Deny
    };
    enum class PartsOfComplexContourObjectsLoadPolicy
    {
        Load,
        Skip
    };
    struct Request
    {
        TOid objectId;
        TUid uid;
        Token dbToken;
        TBranchId branchId;
        SubstitutionPolicy substitutionPolicy;
        PartsOfComplexContourObjectsLoadPolicy partsPolicy;
    };
    explicit GetObject(const Request& request);

    virtual ~GetObject();

    virtual std::string printRequest() const;


private:
    //From controller::BaseController
    virtual void control();

private:
    Request request_;

};

} // namespace wiki
} // namespace maps
