#include "getrenderersublayers.h"

#include "maps/wikimap/mapspro/services/editor/src/check_permissions.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"
#include "maps/wikimap/mapspro/services/editor/src/exception.h"
#include "maps/wikimap/mapspro/services/editor/src/rendererpool.h"
#include "maps/wikimap/mapspro/services/editor/src/acl_utils.h"

#include <maps/wikimap/mapspro/libs/acl/include/exception.h>
#include <yandex/maps/wiki/configs/editor/categories.h>
#include <maps/libs/log8/include/log8.h>

#include <boost/algorithm/string.hpp>

namespace maps {
namespace wiki {

GetLayers::GetLayers(const Request& request)
    : controller::BaseController<GetLayers>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
    result_->requestProjectParams = {
        request_.mapType.empty() ? StringSet{} : StringSet{request_.mapType},
        request_.project.empty() ? StringSet{} : StringSet{request_.project},
        {}
    };

}

std::string GetLayers::printRequest() const
{
    std::ostringstream os;
    os << " mapType: " << request_.mapType;
    os << " project: " << request_.project;
    os << " uid: " << request_.uid;
    return os.str();
}

namespace
{

StringSet
geompartMasters(const std::string& catId)
{
    if (!cfg()->editor()->categories().defined(catId)){
        return {};
    }
    StringSet allGeomPartMasters;
    auto masterCatIds =
        cfg()->editor()->categories()[catId].masterCategoryIds(
            roles::filters::IsGeom);
    for (const auto& masterCatId : masterCatIds) {
        auto masterMasters = geompartMasters(masterCatId);
        allGeomPartMasters.insert(masterMasters.begin(), masterMasters.end());
    }
    allGeomPartMasters.insert(masterCatIds.begin(), masterCatIds.end());
    return allGeomPartMasters;
}

void
buildGroups(RendererLayersTraverse& layersTraverse)
{
    for (const auto& group : layersTraverse.layersByGroup()) {
        const auto& groupId = group.first;
        auto& layersGroup = layersTraverse.layersGroups()[groupId];
        layersGroup.id = groupId;
        for (const auto& layer : group.second) {
            const auto& layerCats = layer->categoryIds();
            for (const auto& catId : layerCats) {
                auto masters = geompartMasters(catId);
                layersGroup.complexCategories.insert(masters.begin(), masters.end());
            }
        }
    }
}
}//namespace

void
GetLayers::control()
{
    cfg()->rendererPool()->acquire()->renderer()->traverse(result_->layersTraverse);
    buildGroups(result_->layersTraverse);
    result_->showFilterTypeLayers = ShowFilterTypeLayers::No;
    if (!request_.uid) {
        return;
    }
    result_->requestProjectParams.aclGroups = userGroups(request_.uid, request_.token);
    auto work = cfg()->poolCore().slaveTransaction(request_.token);
    try {
        if (CheckPermissions(request_.uid, *work).isUserHasAccessToViewFilters()) {
            result_->showFilterTypeLayers = ShowFilterTypeLayers::Yes;
        }
    } catch (const acl::ACLException& ex) {
        WARN() << "Caught ACLException while checking access to renderer layers: " << ex;
    }
}

}//wiki
}//maps
