#pragma once
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/rendererlayerstraverse.h>

namespace maps {
namespace wiki {

class RendererPool;
class GetLayers;

enum class ShowFilterTypeLayers {
    Yes,
    No
};

template<>
struct controller::ResultType<GetLayers>
{
    RendererLayersTraverse layersTraverse;
    RendererLayersTraverse::ProjectParams requestProjectParams;
    ShowFilterTypeLayers showFilterTypeLayers;
};

class GetLayers: public controller::BaseController<GetLayers>
{
public:
    struct Request {
        TUid uid;
        std::string mapType;
        std::string project;
        Token token;
    };
    explicit GetLayers(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
