#pragma once
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class GetLayers2: public controller::BaseController<GetLayers2>
{
public:
    enum class FilterPolicy {
        Filter,
        DoNotFilter
    };

    struct Request {
        TUid uid;
        std::string mapType;
        std::string project;
        Token token;
        FilterPolicy filterByAcl = FilterPolicy::Filter;
    };

    struct ProjectParams
    {
        StringSet mapTypes;
        StringSet projects;
        StringSet aclGroups;
        bool match(const ProjectParams& requested,
                   FilterPolicy filterByAcl) const;
    };

    struct Representation
    {
        std::string id;
        std::string name;
        std::string label;
        std::string type;
        ProjectParams projectParams;
    };

    struct Layer
    {
        std::string id;
        std::string name;
        std::string label;
        std::string type;
        StringSet categories;
        std::list<Representation> representations;
        ProjectParams projectParams;
    };

    struct LayersGroup
    {
        std::string id;
        std::string label;
        std::set<std::string> categories;
        std::list<Layer> layers;
    };

public:
    explicit GetLayers2(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

template<>
struct controller::ResultType<GetLayers2>
{
    std::list<GetLayers2::LayersGroup> groups;
};

} // namespace maps::wiki
