#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/relation_infos.h"

#include <yandex/maps/wiki/common/before_after.h>
#include <yandex/maps/wiki/common/format_type.h>
#include <yandex/maps/wiki/configs/editor/categories.h>

namespace maps {
namespace wiki {

class GetSlaveInfos;
template<>
struct controller::ResultType<GetSlaveInfos>
{
    class SlaveObjectInfo
    {
    public:
        SlaveObjectInfo(TOid id, const std::string& roleId, TOid relationId,
            TRevisionId revisionId, const std::string& screenLabel,
            const std::string& categoryId, const Geom& geom,
            size_t seqNum,
            StringMap&& serviceAttrs)
            : id_(id)
            , roleId_(roleId)
            , relationId_(relationId)
            , revisionId_(revisionId)
            , screenLabel_(screenLabel)
            , categoryId_(categoryId)
            , geom_(geom)
            , seqNum_(seqNum)
            , serviceAttrs_(std::move(serviceAttrs))
        {}

        TOid id() const { return id_; }
        const std::string& roleId() const { return roleId_; }
        TRevisionId revision() const { return revisionId_; }
        const std::string& screenLabel() const { return screenLabel_; }
        const std::string& categoryId() const { return categoryId_; }
        TOid relationId() const { return relationId_; }
        const Geom& geom() const { return geom_; }
        size_t seqNum() const { return seqNum_; }
        const std::string& serviceAttrValue(const std::string& attrName) const;

    private:
        TOid id_;
        std::string roleId_;
        TOid relationId_;
        TRevisionId revisionId_;
        std::string screenLabel_;
        std::string categoryId_;
        Geom geom_;
        size_t seqNum_;
        StringMap serviceAttrs_;
    };
    std::vector<SlaveObjectInfo> slaveInfos;
    std::string roleId;
    std::string bbox;
    size_t limit;
    size_t offset;
    std::optional<bool> hasMore;
};

class GetSlaveInfos: public controller::BaseController<GetSlaveInfos>
{
public:
    struct Request
    {
        TOid oid;
        Token token;
        std::string roleId;
        std::string categoryId;
        size_t offset;
        size_t limit;
        std::string bbox;
        TBranchId branchId;
        common::BeforeAfter beforeAfter;
        TOid startId;
        common::FormatType format;
    };

    explicit GetSlaveInfos(const Request& request);
    virtual ~GetSlaveInfos() {}

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void slavesByBBox(Transaction& work, const Category& slaveCategory);
    void slavesByOffsetAndLimit(Transaction& work, const Category& slaveCategory);

    const Request request_;
};

} // namespace wiki
} // namespace maps
