#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"

namespace maps {
namespace wiki {


class ObjectsCache;
class GeoObjectCollection;
class ObjectsQueryJunction;

template<>
struct controller::ResultType<ObjectsQueryJunction>
{
    ResultType<ObjectsQueryJunction>() : junctionId(0){}
    TOid junctionId;
    std::unique_ptr<ObjectsCache> cache;
    Token token;
    std::string taskName;
};

class ObjectsQueryJunction: public controller::BaseController<ObjectsQueryJunction>
{
public:
    struct Request
    {
        Request(
            const std::string& ptJson,
            TZoom zoom,
            TOid linearElementId,
            UserContext userContext,
            TBranchId branchId,
            boost::optional<TId> feedbackTaskId = boost::none);

        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        Geom point;
        TZoom zoom;
        TOid linearElementId;
        UserContext userContext;
        TBranchId branchId;
        boost::optional<TId> feedbackTaskId;
    };

    ObjectsQueryJunction(const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);
    virtual ~ObjectsQueryJunction(){};

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();
    void saveAndNotify();

private:
    Request request_;
    const ObserverCollection& observers_;

};


} // namespace wiki
} // namespace maps
