#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/commit.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"

namespace maps {
namespace wiki {

class ObjectsCache;
class ObjectsCleanupRelations;
class ObserverCollection;

template<>
struct controller::ResultType<ObjectsCleanupRelations>
{
    std::string taskName;
    Token token;
    std::optional<CommitModel> commit;
};

class ObjectsCleanupRelations: public controller::BaseController<ObjectsCleanupRelations>
{
public:
    struct Request
    {
        UserContext userContext;
        TOid objectId;
        TBranchId branchId;

        std::string dump() const;
        TUid userId() const { return userContext.uid(); }
    };

    ObjectsCleanupRelations(
        const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    std::string printRequest() const override;

protected:
    void control() override;

    void saveAndNotify(ObjectsCache&);

private:
    const ObserverCollection& observers_;

    Request request_;
};

} // namespace wiki
} // namespace maps
