#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/collection.h"

#include <memory>

namespace maps {
namespace wiki {

class ObjectsCache;

class ObjectsQueryCategory : public controller::BaseController<ObjectsQueryCategory>
{
public:
    struct Request
    {
        std::string categoryId;
        TUid uid;
        Token dbToken;
        TBranchId branchId;
    };

    explicit ObjectsQueryCategory(const Request& request);
    ~ObjectsQueryCategory();

    virtual std::string printRequest() const;

private:
    //From controller::BaseController
    virtual void control();

private:
    Request request_;
};

template<>
struct controller::ResultType<ObjectsQueryCategory>
{
    GeoObjectCollection collection;
    std::unique_ptr<ObjectsCache> cache;
};

} // wiki
} // maps
