#include "objects_query_filter.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"
#include "maps/wikimap/mapspro/services/editor/src/branch_helpers.h"
#include "maps/wikimap/mapspro/services/editor/src/views/objects_query.h"

#include <maps/wikimap/mapspro/libs/views/include/query_builder.h>
#include <yandex/maps/wiki/configs/editor/categories.h>

namespace maps {
namespace wiki {

namespace {

const std::string CATEGORY_KEY_PREFIX = "cat:";

} // namespace


ObjectsQueryFilter::ObjectsQueryFilter(
        const Request& request)
    : controller::BaseController<ObjectsQueryFilter>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
    result_->totalCount = 0;
    result_->limit = request_.limit;
}

std::string
ObjectsQueryFilter::printRequest() const
{
    std::stringstream ss;
    ss << "expressionId: " << request_.expressionId
       << " geom: " << request_.geomJson
       << " branch: " << request_.branchId
       << " token: " << request_.token;
    return ss.str();
}

void
ObjectsQueryFilter::control()
{
    Geom aoi(createGeomFromJsonStr(request_.geomJson));
    if (aoi.isNull()) {
        return;
    }

    auto branchCtx = BranchContextFacade::acquireRead(
            request_.branchId, request_.token);
    auto expr = filters::StoredExpression::load(
        branchCtx.txnCore(), request_.expressionId);

    auto filterSql = expr.parsed().viewFilterClause(branchCtx.txnView());

    views::ObjectsQuery objectsQuery;
    objectsQuery.addCondition(views::GenericSqlCondition(filterSql));
    objectsQuery.addCondition(views::CoveredByGeometryCondition(branchCtx.txnView(), aoi));

    views::QueryBuilder qb(request_.branchId);
    qb.selectFields("skeys(domain_attrs) as category_id");
    qb.fromTable(views::TABLE_OBJECTS_G, "g");
    qb.whereClause(objectsQuery.whereClause());

    auto statsQuery =
        "SELECT category_id, count(*) as count"
        " FROM (" + qb.query() + ") foo"
        " WHERE category_id LIKE '" + CATEGORY_KEY_PREFIX + "' || '%'"
        " GROUP BY category_id";

    for (const auto& row : branchCtx.txnView().exec(statsQuery)) {
        auto catKey = row["category_id"].as<std::string>();
        REQUIRE(catKey.starts_with(CATEGORY_KEY_PREFIX),
                "bad category key: " << catKey);
        auto catId = catKey.substr(CATEGORY_KEY_PREFIX.length());

        if (cfg()->editor()->categories().defined(catId)) {
            auto count = row["count"].as<size_t>();
            result_->countsByCategory[catId] += count;
            result_->totalCount += count;
        }
    }

    if (result_->totalCount <= request_.limit) {
        result_->viewObjects = objectsQuery.exec(
            branchCtx.txnView(), request_.branchId, request_.limit);
    }
}

} // namespace wiki
} // namespace maps
