#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <yandex/maps/wiki/filters/stored_expression.h>

#include <memory>

namespace maps {
namespace wiki {
class ObjectsQueryFilter;
template<>
struct controller::ResultType<ObjectsQueryFilter>
{
    views::ViewObjects viewObjects;
    std::map<std::string, size_t> countsByCategory;
    size_t totalCount;
    size_t limit;
};

class ObjectsQueryFilter : public controller::BaseController<ObjectsQueryFilter>
{
public:
    struct Request
    {
        filters::TExpressionId expressionId;
        std::string geomJson;
        TBranchId branchId;
        Token token;
        size_t limit;
    };

    explicit ObjectsQueryFilter(const Request& request);

    virtual std::string printRequest() const;

private:
    virtual void control();

    Request request_;
};

} // namespace wiki
} // namespace maps
