#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/collection.h"
#include <maps/libs/common/include/enum_bitset.h>

#include <memory>

namespace maps::wiki {

class ObjectsCache;

class ObjectsQueryIds : public controller::BaseController<ObjectsQueryIds>
{
public:
    enum class SerializeDetails : unsigned
    {
        Brief,
        Attrs,
        Permissions,
        Masters,
        EnumBitsetFlagsEnd
    };

    enum class IdsFormat
    {
        JsonArray,
        CSV
    };

    using SerializeDetailsFlags = maps::common::EnumBitset<SerializeDetails>;

    struct Request
    {
        Request(
            IdsFormat idsFormat,
            const std::string& oidsStr,
            SerializeDetailsFlags serializeDetailsFlags,
            TUid uid,
            Token token,
            TBranchId branchId);

        std::vector<TOid> objectIds;
        SerializeDetailsFlags serializeDetailsFlags;
        TUid uid;
        Token dbToken;
        TBranchId branchId;
    };

    explicit ObjectsQueryIds(const Request& request);
    ~ObjectsQueryIds();

    virtual std::string printRequest() const;

private:
    //From controller::BaseController
    virtual void control();

private:
    Request request_;

    std::unique_ptr<ObjectsCache> cache_;
};

template<>
struct controller::ResultType<ObjectsQueryIds>
{
    GeoObjectCollection collection;
    ObjectsQueryIds::SerializeDetailsFlags serializeDetailsFlags;
};

} // namespace maps::wiki
