#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <yandex/maps/wiki/filters/common.h>

#include <optional>

namespace maps {
namespace wiki {

class ObjectsQueryLasso;
template<>
struct controller::ResultType<ObjectsQueryLasso>
{
    views::ViewObjects viewObjects;
};

class ObjectsQueryLasso : public controller::BaseController<ObjectsQueryLasso>
{
public:
    enum class GeomPredicate
    {
        CoveredBy,
        Intersects
    };

    enum class SubstitutionPolicy
    {
        Allow,
        Deny
    };

    struct Request
    {
        std::string dump() const;

        std::string categories;
        std::string geomJson;
        std::optional<double> threshold;
        Token dbToken;
        TBranchId branchId;
        size_t limit;
        GeomPredicate predicate;
        std::optional<TOid> indoorLevelId;
        std::optional<filters::TExpressionId> expressionId;
        SubstitutionPolicy substitutionPolicy;
    };

    explicit ObjectsQueryLasso(const Request& request);

    virtual ~ObjectsQueryLasso() {}

    virtual std::string printRequest() const;

protected:
    virtual void control();

    Request request_;


};

}//wiki
}//maps
