#include "objects_query_lasso_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/check_permissions.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"
#include "maps/wikimap/mapspro/services/editor/src/objects/category_traits.h"
#include <yandex/maps/wiki/configs/editor/categories.h>

namespace maps::wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsQueryLassoMeta";
constexpr size_t MAX_OBJECTS = 1000;
} // namespace

ObjectsQueryLassoMeta::ObjectsQueryLassoMeta(const Request& request)
    : controller::BaseController<ObjectsQueryLassoMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsQueryLassoMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsQueryLassoMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsQueryLassoMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsQueryLassoMeta::control()
{
    try {
        if (!request_.uid) {
            return;
        }
        auto work = cfg()->poolCore().slaveTransaction();
        CheckPermissions permissionsChecker(request_.uid, *work);
        const auto& categories = cfg()->editor()->categories();
        for (const auto& [id, _] : categories) {
            if ((isSimpleGeomCategory(id) ||
                    isContourObjectCategory(id)) &&
                !isJunction(id) &&
                permissionsChecker.isUserHasAccessToViewCategory(id))
            {
                result_->categoryIds.insert(id);
            }
        }
    } catch (const std::exception& ex) {
        WARN() << "Caught exception while checking access" << ex.what();
        return;
    }
    result_->maxObjects = MAX_OBJECTS;
}

} // namespace maps::wiki
