#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ObjectsQueryLassoMeta;

template<>
struct controller::ResultType<ObjectsQueryLassoMeta>
{
    StringSet categoryIds;
    size_t maxObjects = 0;
};

class ObjectsQueryLassoMeta
    : public controller::BaseController<ObjectsQueryLassoMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsQueryLassoMeta(const Request& request);

    virtual ~ObjectsQueryLassoMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
