#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <optional>

namespace maps::wiki {

class ObjectsQueryPoiBusinessId;
template<>
struct controller::ResultType<ObjectsQueryPoiBusinessId>
{
    views::ViewObjects viewObjects;
};

class ObjectsQueryPoiBusinessId : public controller::BaseController<ObjectsQueryPoiBusinessId>
{
public:
    struct Request
    {
        std::string dump() const;
        std::string businessId;
        std::string geomJson;
        std::optional<double> distance;
        Token dbToken;
        TBranchId branchId;
    };

    explicit ObjectsQueryPoiBusinessId(const Request& request);

    virtual ~ObjectsQueryPoiBusinessId() {}

    virtual std::string printRequest() const;

protected:
    virtual void control();
    Request request_;
};

} // namespace maps::wiki
