#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "poi_conflicts_common.h"
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <maps/wikimap/mapspro/libs/poi_conflicts/include/poi_conflicts.h>
#include <yandex/maps/wiki/filters/common.h>

#include <map>
#include <optional>

namespace maps::wiki {

class ObjectsQueryPoiConflicts;
template<>
struct controller::ResultType<ObjectsQueryPoiConflicts>
{
    PoiConflictsData viewObjectsConflicts;
};


class ObjectsQueryPoiConflicts : public controller::BaseController<ObjectsQueryPoiConflicts>
{
public:
    struct Request
    {
        enum class IsGeoproductParam
        {
            True,
            False
        };

        std::string dump() const;
        std::string geomJson;
        Token dbToken;
        TBranchId branchId;
        std::optional<TOid> indoorLevelId;
        std::optional<TOid> objectId;
        IsGeoproductParam isGeoproduct;
        TUid uid;
    };

    explicit ObjectsQueryPoiConflicts(const Request& request);

    virtual std::string printRequest() const;
    static const std::string& taskName();

protected:
    virtual void control();

    Request request_;
};

}// namespace maps::wiki
