#include "objects_query_pois_conflicts_meta.h"

#include "poi_conflicts_common.h"

#include "maps/wikimap/mapspro/services/editor/src/check_permissions.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"
#include <yandex/maps/wiki/configs/editor/categories.h>
#include <yandex/maps/wiki/configs/editor/category_groups.h>

namespace maps::wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsQueryPoisConflictsMeta";
} // namespace

ObjectsQueryPoisConflictsMeta::ObjectsQueryPoisConflictsMeta(const Request& request)
    : controller::BaseController<ObjectsQueryPoisConflictsMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsQueryPoisConflictsMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsQueryPoisConflictsMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsQueryPoisConflictsMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsQueryPoisConflictsMeta::control()
{
    try {
        if (!request_.uid) {
            return;
        }
        auto work = cfg()->poolCore().slaveTransaction();
        CheckPermissions(request_.uid, *work).checkAccessToPoisConflictsTool();
    } catch (const std::exception& ex) {
        WARN() << "Caught exception while checking access" << ex.what();
        return;
    }
    result_->categoryIds = poiCategoryIds();
    result_->maxObjects = 200;
}

} // namespace maps::wiki
