#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ObjectsQueryPoisConflictsMeta;

template<>
struct controller::ResultType<ObjectsQueryPoisConflictsMeta>
{
    StringSet categoryIds;
    size_t maxObjects = 0;
};

class ObjectsQueryPoisConflictsMeta
    : public controller::BaseController<ObjectsQueryPoisConflictsMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsQueryPoisConflictsMeta(const Request& request);

    virtual ~ObjectsQueryPoisConflictsMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
