#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <yandex/maps/wiki/filters/common.h>

#include <optional>

namespace maps::wiki {

class ObjectsQueryTitle;
template<>
struct controller::ResultType<ObjectsQueryTitle>
{
    views::ViewObjects viewObjects;
};

class ObjectsQueryTitle : public controller::BaseController<ObjectsQueryTitle>
{
public:
    enum class GeomPredicate
    {
        CoveredBy,
        Intersects
    };

    struct Request
    {
        std::string dump() const;
        std::string categories;
        std::string searchText;
        Geom geom;
        std::string ll;
        double distance;
        Token dbToken;
        TBranchId branchId;
        size_t limit;
        std::optional<TOid> indoorLevelId;
    };

    explicit ObjectsQueryTitle(const Request& request);

    virtual ~ObjectsQueryTitle() {}

    virtual std::string printRequest() const;

protected:
    virtual void control();

    Request request_;
};

} // namespace maps::wiki
