#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/commit.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class ObjectsCache;
class GeoObjectCollection;
class ObjectsUpdateAttributes;

template<>
struct controller::ResultType<ObjectsUpdateAttributes>
{
    std::string taskName;
    Token token;
    std::optional<CommitModel> commit;
};

class ObjectsUpdateAttributes
    : public controller::BaseController<ObjectsUpdateAttributes>
{
public:
    struct Request
    {
        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        std::string body;
        UserContext userContext;
        TBranchId branchId;
        boost::optional<TId> feedbackTaskId;
        common::FormatType format;
    };

    ObjectsUpdateAttributes(const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);
    virtual ~ObjectsUpdateAttributes() = default;

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

    void saveAndNotify(
        GeoObjectCollection& objectContainer,
        ObjectsCache& cache);

private:
    Request request_;
    const ObserverCollection& observers_;

};

} // namespace wiki
} // namespace maps
