#include "objects_update_attributes_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

namespace maps {
namespace wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsUpdateAttributesMeta";
const std::string ACTION_ID_UPDATE_ATTRIBUTES = "update-attributes";
}

ObjectsUpdateAttributesMeta::ObjectsUpdateAttributesMeta(const Request& request)
    : controller::BaseController<ObjectsUpdateAttributesMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsUpdateAttributesMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsUpdateAttributesMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsUpdateAttributesMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsUpdateAttributesMeta::control()
{
    const auto& updateRestrictions = cfg()->editor()->objectsUpdateRestrictions();
    result_->attrIdsByCategoryId = updateRestrictions.groupAttrIdsByCategoryId();
    result_->maxObjects = updateRestrictions.maxObjects(ACTION_ID_UPDATE_ATTRIBUTES);
}

} // namespace wiki
} // namespace maps
