#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class ObjectsUpdateAttributesMeta;

template<>
struct controller::ResultType<ObjectsUpdateAttributesMeta>
{
    std::map<std::string, StringSet> attrIdsByCategoryId;
    size_t maxObjects;
};

class ObjectsUpdateAttributesMeta
    : public controller::BaseController<ObjectsUpdateAttributesMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsUpdateAttributesMeta(const Request& request);

    virtual ~ObjectsUpdateAttributesMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
