#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/commit.h"
#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"
#include <yandex/maps/wiki/common/format_type.h>

#include <string>
#include <sstream>


namespace maps {
namespace wiki {

class ObjectsUpdateMerge;

template<>
struct controller::ResultType<ObjectsUpdateMerge>
{
    std::string taskName;
    Token token;
    std::optional<CommitModel> commit;
};

class ObjectsUpdateMerge: public controller::BaseController<ObjectsUpdateMerge>
{
public:
    struct Request
    {
        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        std::string body;
        UserContext userContext;
        TBranchId branchId;
        common::FormatType format;
    };

    ObjectsUpdateMerge(
            const ObserverCollection& observers,
            const Request& request,
            taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

    void saveAndNotify(ObjectsCache& cache);

private:
    const ObserverCollection& observers_;
    Request request_;
};


} // namespace wiki
} // namespace maps
