#include "objects_update_move_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

namespace maps {
namespace wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsUpdateMoveMeta";
const std::string ACTION_ID_MOVE = "move";
}

ObjectsUpdateMoveMeta::ObjectsUpdateMoveMeta(const Request& request)
    : controller::BaseController<ObjectsUpdateMoveMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsUpdateMoveMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsUpdateMoveMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsUpdateMoveMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsUpdateMoveMeta::control()
{
    const auto& updateRestrictions = cfg()->editor()->objectsUpdateRestrictions();
    result_->categoryIds = updateRestrictions.actionCategoryIds(ACTION_ID_MOVE);
    result_->maxObjects = updateRestrictions.maxObjects(ACTION_ID_MOVE);
}

} // namespace wiki
} // namespace maps
