#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class ObjectsUpdateMoveMeta;

template<>
struct controller::ResultType<ObjectsUpdateMoveMeta>
{
    StringSet categoryIds;
    size_t maxObjects;
};

class ObjectsUpdateMoveMeta
    : public controller::BaseController<ObjectsUpdateMoveMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsUpdateMoveMeta(const Request& request);

    virtual ~ObjectsUpdateMoveMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
