#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "maps/wikimap/mapspro/services/editor/src/commit.h"
#include "maps/wikimap/mapspro/services/editor/src/observers/observer.h"
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class ObjectsCache;
class GeoObjectCollection;
class ObjectsUpdateRelations;

template<>
struct controller::ResultType<ObjectsUpdateRelations>
{
    std::string taskName;
    Token token;
    std::optional<CommitModel> commit;
};

class ObjectsUpdateRelations
    : public controller::BaseController<ObjectsUpdateRelations>
{
public:
    struct Request
    {
        std::string dump() const;
        TUid userId() const { return userContext.uid(); }

        std::string body;
        UserContext userContext;
        TBranchId branchId;
        boost::optional<TId> feedbackTaskId;
        common::FormatType format;
    };

    ObjectsUpdateRelations(const ObserverCollection& observers,
        Request request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    std::string printRequest() const override;

protected:
    void control() override;

    void saveAndNotify(
        GeoObjectCollection& objectContainer,
        ObjectsCache& cache);

private:
    Request request_;
    const ObserverCollection& observers_;

};

} // namespace wiki
} // namespace maps
