#include "objects_update_relations_meta.h"

#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

namespace maps {
namespace wiki {

namespace {
const std::string TASK_METHOD_NAME = "ObjectsUpdateRelationsMeta";
const std::string ACTION_ID = "update-relations";
}

ObjectsUpdateRelationsMeta::ObjectsUpdateRelationsMeta(const Request& request)
    : controller::BaseController<ObjectsUpdateRelationsMeta>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
ObjectsUpdateRelationsMeta::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
ObjectsUpdateRelationsMeta::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    return ss.str();
}

std::string
ObjectsUpdateRelationsMeta::printRequest() const
{
    return request_.dump();
}

void
ObjectsUpdateRelationsMeta::control()
{
    const auto& updateRestrictions = cfg()->editor()->objectsUpdateRestrictions();
    result_->categoryIds = updateRestrictions.actionCategoryIds(ACTION_ID);
    result_->maxObjects = updateRestrictions.maxObjects(ACTION_ID);
}

} // namespace wiki
} // namespace maps
