#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ObjectsUpdateRelationsMeta;

template<>
struct controller::ResultType<ObjectsUpdateRelationsMeta>
{
    StringSet categoryIds;
    size_t maxObjects;
};

class ObjectsUpdateRelationsMeta
    : public controller::BaseController<ObjectsUpdateRelationsMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ObjectsUpdateRelationsMeta(const Request& request);

    virtual ~ObjectsUpdateRelationsMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
